/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.objectAccess.table;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.WordUtils;

public enum DelimiterType {
    COMMA("comma", ','),
    SEMICOLON("semicolon", ';'),
    HORIZONTAL_TAB("horizontal tab", '\t'),
    VERTICAL_BAR("vertical bar", '|'),
    CARRIAGE_RETURN_LINE_FEED("carriage-return line-feed", "\r\n");

    private static Map<String, DelimiterType> xmlTypeMap;
    private String xmlType;
    private String recordDelimiter;
    private char fieldDelimiter;

    private DelimiterType(String xmlType, char fieldDelimiter) {
        this.xmlType = xmlType;
        this.fieldDelimiter = fieldDelimiter;
    }

    private DelimiterType(String xmlType, String recordDelimiter) {
        this.xmlType = xmlType;
        this.recordDelimiter = recordDelimiter;
    }

    public static DelimiterType getDelimiterType(String xmlType) {
        DelimiterType type = xmlTypeMap.get(xmlType.toLowerCase());
        if (type == null) {
            throw new IllegalArgumentException("No delimiter type definition found for XML type (" + xmlType + ")");
        }
        return type;
    }

    public String getXmlType() {
        return WordUtils.capitalize((String)this.xmlType, (char[])new char[]{' ', '-'});
    }

    public char getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public String getRecordDelimiter() {
        return this.recordDelimiter;
    }

    static {
        xmlTypeMap = new HashMap<String, DelimiterType>();
        for (DelimiterType type : DelimiterType.values()) {
            xmlTypeMap.put(type.getXmlType().toLowerCase(), type);
        }
    }
}

