/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.objectAccess;

import gov.nasa.pds.label.object.FieldDescription;
import gov.nasa.pds.label.object.FieldType;
import gov.nasa.pds.label.object.RecordLocation;
import gov.nasa.pds.label.object.TableRecord;
import gov.nasa.pds.objectAccess.table.DefaultFieldAdapter;
import gov.nasa.pds.objectAccess.table.DelimiterType;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedTableRecord
implements TableRecord {
    private Charset charset;
    private ByteBuffer buffer = null;
    private byte[] recordBytes = null;
    private Map<String, Integer> fieldMap = new HashMap<String, Integer>();
    private FieldDescription[] fields;
    private RecordLocation location;
    private static final Logger LOGGER = LoggerFactory.getLogger(FixedTableRecord.class);

    FixedTableRecord(int length, Map<String, Integer> map, FieldDescription[] fields, Charset charset, boolean isBinary) {
        this.charset = charset;
        this.fieldMap = map;
        this.fields = fields;
        this.buffer = ByteBuffer.allocate(length);
        this.location = null;
        if (!isBinary) {
            String delimiter = DelimiterType.CARRIAGE_RETURN_LINE_FEED.getRecordDelimiter();
            Arrays.fill(this.buffer.array(), (byte)32);
            this.buffer.position(length - delimiter.getBytes(charset).length);
            this.setString(delimiter);
        }
    }

    public FixedTableRecord(byte[] value, Map<String, Integer> map, FieldDescription[] fields) {
        this.fieldMap = map;
        this.fields = fields;
        this.location = null;
        this.setRecordValue(value);
    }

    @Override
    public int findColumn(String name) {
        this.checkFieldName(name);
        return this.fieldMap.get(name);
    }

    @Override
    public boolean getBoolean(String name) {
        this.checkFieldName(name);
        return this.getBoolean(this.fieldMap.get(name));
    }

    @Override
    public boolean getBoolean(int index) {
        FieldDescription field = this.getField(index);
        String value = field.getType().getAdapter().getString(this.recordBytes, field.getOffset(), field.getLength(), field.getStartBit(), field.getStopBit()).trim();
        if (value.equals("true") || value.equals("1")) {
            return true;
        }
        if (value.equals("false") || value.equals("0")) {
            return false;
        }
        throw new IllegalArgumentException("Field value is not a valid boolean (" + value + ")");
    }

    @Override
    public short getShort(int index) {
        FieldDescription field = this.getField(index);
        return field.getType().getAdapter().getShort(this.recordBytes, field.getOffset(), field.getLength(), field.getStartBit(), field.getStopBit());
    }

    @Override
    public short getShort(String name) {
        this.checkFieldName(name);
        return this.getShort(this.fieldMap.get(name));
    }

    @Override
    public byte getByte(int index) {
        FieldDescription field = this.getField(index);
        return field.getType().getAdapter().getByte(this.recordBytes, field.getOffset(), field.getLength(), field.getStartBit(), field.getStopBit());
    }

    @Override
    public byte getByte(String name) {
        this.checkFieldName(name);
        return this.getByte(this.fieldMap.get(name));
    }

    @Override
    public long getLong(int index) {
        FieldDescription field = this.getField(index);
        return field.getType().getAdapter().getLong(this.recordBytes, field.getOffset(), field.getLength(), field.getStartBit(), field.getStopBit());
    }

    @Override
    public long getLong(String name) {
        this.checkFieldName(name);
        return this.getLong(this.fieldMap.get(name));
    }

    @Override
    public int getInt(String name) {
        this.checkFieldName(name);
        return this.getInt(this.fieldMap.get(name));
    }

    @Override
    public int getInt(int index) {
        FieldDescription field = this.getField(index);
        return field.getType().getAdapter().getInt(this.recordBytes, field.getOffset(), field.getLength(), field.getStartBit(), field.getStopBit());
    }

    @Override
    public BigInteger getBigInteger(String name) {
        this.checkFieldName(name);
        return this.getBigInteger(this.fieldMap.get(name));
    }

    @Override
    public BigInteger getBigInteger(int index) {
        FieldDescription field = this.getField(index);
        return field.getType().getAdapter().getBigInteger(this.recordBytes, field.getOffset(), field.getLength(), field.getStartBit(), field.getStopBit());
    }

    @Override
    public double getDouble(String name) {
        this.checkFieldName(name);
        return this.getDouble(this.fieldMap.get(name));
    }

    @Override
    public double getDouble(int index) {
        FieldDescription field = this.getField(index);
        return field.getType().getAdapter().getDouble(this.recordBytes, field.getOffset(), field.getLength(), field.getStartBit(), field.getStopBit());
    }

    @Override
    public float getFloat(String name) {
        this.checkFieldName(name);
        return this.getFloat(this.fieldMap.get(name));
    }

    @Override
    public float getFloat(int index) {
        FieldDescription field = this.getField(index);
        return field.getType().getAdapter().getFloat(this.recordBytes, field.getOffset(), field.getLength(), field.getStartBit(), field.getStopBit());
    }

    @Override
    public String getString(String name) {
        this.checkFieldName(name);
        return this.getString(this.fieldMap.get(name));
    }

    @Override
    public String getString(String name, Charset charset) {
        this.checkFieldName(name);
        return this.getString(this.fieldMap.get(name), charset);
    }

    @Override
    public String getString(int index) {
        FieldDescription field = this.getField(index);
        return field.getType().getAdapter().getString(this.recordBytes, field.getOffset(), field.getLength(), field.getStartBit(), field.getStopBit());
    }

    @Override
    public String getString(int index, Charset charset) {
        FieldDescription field = this.getField(index);
        return field.getType().getAdapter().getString(this.recordBytes, field.getOffset(), field.getLength(), field.getStartBit(), field.getStopBit(), charset);
    }

    @Override
    public void setString(int index, String value) {
        FieldDescription field = this.getField(index);
        FieldType type = field.getType();
        type.getAdapter().setString(value, field.getOffset(), field.getLength(), this.buffer, type.isRightJustified(), this.charset);
    }

    @Override
    public void setString(String name, String value) {
        this.checkFieldName(name);
        this.setString(this.fieldMap.get(name), value);
    }

    @Override
    public void setString(String value) {
        DefaultFieldAdapter adapter = new DefaultFieldAdapter();
        adapter.setString(value, this.buffer, this.charset);
    }

    @Override
    public void setInt(int index, int value) {
        FieldDescription field = this.getField(index);
        FieldType type = field.getType();
        type.getAdapter().setInt(value, field.getOffset(), field.getLength(), this.buffer, type.isRightJustified());
    }

    @Override
    public void setInt(String name, int value) {
        this.checkFieldName(name);
        this.setInt(this.fieldMap.get(name), value);
    }

    @Override
    public void setDouble(int index, double value) {
        FieldDescription field = this.getField(index);
        FieldType type = field.getType();
        type.getAdapter().setDouble(value, field.getOffset(), field.getLength(), this.buffer, type.isRightJustified());
    }

    @Override
    public void setDouble(String name, double value) {
        this.checkFieldName(name);
        this.setDouble(this.fieldMap.get(name), value);
    }

    @Override
    public void setFloat(int index, float value) {
        FieldDescription field = this.getField(index);
        FieldType type = field.getType();
        type.getAdapter().setFloat(value, field.getOffset(), field.getLength(), this.buffer, type.isRightJustified());
    }

    @Override
    public void setFloat(String name, float value) {
        this.checkFieldName(name);
        this.setFloat(this.fieldMap.get(name), value);
    }

    @Override
    public void setLong(int index, long value) {
        FieldDescription field = this.getField(index);
        FieldType type = field.getType();
        type.getAdapter().setLong(value, field.getOffset(), field.getLength(), this.buffer, type.isRightJustified());
    }

    @Override
    public void setLong(String name, long value) {
        this.checkFieldName(name);
        this.setLong(this.fieldMap.get(name), value);
    }

    @Override
    public void setShort(int index, short value) {
        FieldDescription field = this.getField(index);
        FieldType type = field.getType();
        type.getAdapter().setShort(value, field.getOffset(), field.getLength(), this.buffer, type.isRightJustified());
    }

    @Override
    public void setShort(String name, short value) {
        this.checkFieldName(name);
        this.setShort(this.fieldMap.get(name), value);
    }

    @Override
    public void setByte(int index, byte value) {
        FieldDescription field = this.getField(index);
        FieldType type = field.getType();
        type.getAdapter().setByte(value, field.getOffset(), field.getLength(), this.buffer, type.isRightJustified());
    }

    @Override
    public void setByte(String name, byte value) {
        this.checkFieldName(name);
        this.setByte(this.fieldMap.get(name), value);
    }

    @Override
    public void clear() {
        this.buffer.clear();
    }

    public void setRecordValue(byte[] value) {
        this.recordBytes = value;
    }

    public byte[] getRecordValue() {
        return this.buffer.array();
    }

    private FieldDescription getField(int index) {
        if (index <= 0 || index > this.fields.length) {
            String msg = "The index is out of range (1 to " + this.fields.length + ").";
            LOGGER.error(msg);
            throw new ArrayIndexOutOfBoundsException(msg);
        }
        return this.fields[index - 1];
    }

    private void checkFieldName(String name) {
        if (!this.fieldMap.containsKey(name)) {
            String msg = "'" + name + "' is not a valid field name.";
            LOGGER.error(msg);
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public RecordLocation getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(RecordLocation location) {
        this.location = location;
    }
}

