/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.ExifIFD0Directory;
import java.io.UnsupportedEncodingException;

public class ExifIFD0Descriptor
extends TagDescriptor<ExifIFD0Directory> {
    private final boolean _allowDecimalRepresentationOfRationals = true;

    public ExifIFD0Descriptor(@NotNull ExifIFD0Directory exifIFD0Directory) {
        super(exifIFD0Directory);
    }

    @Override
    @Nullable
    public String getDescription(int n) {
        switch (n) {
            case 296: {
                return this.getResolutionDescription();
            }
            case 531: {
                return this.getYCbCrPositioningDescription();
            }
            case 282: {
                return this.getXResolutionDescription();
            }
            case 283: {
                return this.getYResolutionDescription();
            }
            case 532: {
                return this.getReferenceBlackWhiteDescription();
            }
            case 274: {
                return this.getOrientationDescription();
            }
            case 40093: {
                return this.getWindowsAuthorDescription();
            }
            case 40092: {
                return this.getWindowsCommentDescription();
            }
            case 40094: {
                return this.getWindowsKeywordsDescription();
            }
            case 40095: {
                return this.getWindowsSubjectDescription();
            }
            case 40091: {
                return this.getWindowsTitleDescription();
            }
        }
        return super.getDescription(n);
    }

    @Nullable
    public String getReferenceBlackWhiteDescription() {
        int[] nArray = ((ExifIFD0Directory)this._directory).getIntArray(532);
        if (nArray == null) {
            return null;
        }
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        int n5 = nArray[4];
        int n6 = nArray[5];
        return "[" + n + "," + n3 + "," + n5 + "] " + "[" + n2 + "," + n4 + "," + n6 + "]";
    }

    @Nullable
    public String getYResolutionDescription() {
        Rational rational = ((ExifIFD0Directory)this._directory).getRational(283);
        if (rational == null) {
            return null;
        }
        String string = this.getResolutionDescription();
        return rational.toSimpleString(true) + " dots per " + (string == null ? "unit" : string.toLowerCase());
    }

    @Nullable
    public String getXResolutionDescription() {
        Rational rational = ((ExifIFD0Directory)this._directory).getRational(282);
        if (rational == null) {
            return null;
        }
        String string = this.getResolutionDescription();
        return rational.toSimpleString(true) + " dots per " + (string == null ? "unit" : string.toLowerCase());
    }

    @Nullable
    public String getYCbCrPositioningDescription() {
        Integer n = ((ExifIFD0Directory)this._directory).getInteger(531);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "Center of pixel array";
            }
            case 2: {
                return "Datum point";
            }
        }
        return String.valueOf(n);
    }

    @Nullable
    public String getOrientationDescription() {
        Integer n = ((ExifIFD0Directory)this._directory).getInteger(274);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "Top, left side (Horizontal / normal)";
            }
            case 2: {
                return "Top, right side (Mirror horizontal)";
            }
            case 3: {
                return "Bottom, right side (Rotate 180)";
            }
            case 4: {
                return "Bottom, left side (Mirror vertical)";
            }
            case 5: {
                return "Left side, top (Mirror horizontal and rotate 270 CW)";
            }
            case 6: {
                return "Right side, top (Rotate 90 CW)";
            }
            case 7: {
                return "Right side, bottom (Mirror horizontal and rotate 90 CW)";
            }
            case 8: {
                return "Left side, bottom (Rotate 270 CW)";
            }
        }
        return String.valueOf(n);
    }

    @Nullable
    public String getResolutionDescription() {
        Integer n = ((ExifIFD0Directory)this._directory).getInteger(296);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "(No unit)";
            }
            case 2: {
                return "Inch";
            }
            case 3: {
                return "cm";
            }
        }
        return "";
    }

    @Nullable
    private String getUnicodeDescription(int n) {
        byte[] byArray = ((ExifIFD0Directory)this._directory).getByteArray(n);
        if (byArray == null) {
            return null;
        }
        try {
            return new String(byArray, "UTF-16LE").trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    @Nullable
    public String getWindowsAuthorDescription() {
        return this.getUnicodeDescription(40093);
    }

    @Nullable
    public String getWindowsCommentDescription() {
        return this.getUnicodeDescription(40092);
    }

    @Nullable
    public String getWindowsKeywordsDescription() {
        return this.getUnicodeDescription(40094);
    }

    @Nullable
    public String getWindowsTitleDescription() {
        return this.getUnicodeDescription(40091);
    }

    @Nullable
    public String getWindowsSubjectDescription() {
        return this.getUnicodeDescription(40095);
    }
}

