/*
 * Decompiled with CFR 0.152.
 */
package dods.servers.test;

import dods.dap.BaseType;
import dods.dap.DConstructor;
import dods.dap.DODSException;
import dods.dap.Server.CEEvaluator;
import dods.dap.Server.ClauseFactory;
import dods.dap.Server.FunctionLibrary;
import dods.dap.Server.ServerDDS;
import dods.dap.parser.ParseException;
import dods.servers.test.testDataset;
import dods.servers.test.testEngine;
import dods.servers.test.test_SDArray;
import dods.servlet.DODSServlet;
import dods.servlet.GuardedDataset;
import dods.servlet.ReqState;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.zip.DeflaterOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class dts
extends DODSServlet {
    private static FunctionLibrary functionLibrary = new FunctionLibrary("dods.servers.test.SSF");
    private String ServerVersion = "DODS/3.2";

    public String getServerVersion() {
        return this.ServerVersion;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setHeader("Last-Modified", new Date().toString());
        super.doGet(request, response);
    }

    public void doGetDODS(HttpServletRequest request, HttpServletResponse response, ReqState rs) throws IOException, ServletException {
        FilterOutputStream bOut;
        System.out.println("Sending DODS Data For: " + rs.getDataSet());
        response.setContentType("application/octet-stream");
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setHeader("Content-Description", "dods_data");
        ServletOutputStream sOut = response.getOutputStream();
        if (rs.getAcceptsCompressed()) {
            response.setHeader("Content-Encoding", "deflate");
            bOut = new DeflaterOutputStream((OutputStream)sOut);
        } else {
            bOut = new BufferedOutputStream((OutputStream)sOut);
        }
        try {
            GuardedDataset ds = this.getDataset(rs);
            ServerDDS myDDS = ds.getDDS();
            this.cacheArrayShapes(myDDS);
            CEEvaluator ce = new CEEvaluator(myDDS, new ClauseFactory(functionLibrary));
            ce.parseConstraint(rs.getConstraintExpression());
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(bOut));
            myDDS.printConstrained(pw);
            pw.flush();
            ((OutputStream)bOut).write("\nData:\n".getBytes());
            ((OutputStream)bOut).flush();
            DataOutputStream sink = new DataOutputStream(bOut);
            testEngine te = new testEngine();
            ce.send(myDDS.getName(), sink, te);
            sink.flush();
            if (rs.getAcceptsCompressed()) {
                ((DeflaterOutputStream)bOut).finish();
            }
        }
        catch (DODSException de) {
            this.dodsExceptionHandler(de, response);
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, response);
        }
        response.setStatus(200);
    }

    private void cacheArrayShapes(ServerDDS sdds) {
        Enumeration e = sdds.getVariables();
        while (e.hasMoreElements()) {
            BaseType bt = (BaseType)e.nextElement();
            this.cAS(bt);
        }
    }

    private void cAS(BaseType bt) {
        if (bt instanceof DConstructor) {
            Enumeration e = ((DConstructor)bt).getVariables();
            while (e.hasMoreElements()) {
                BaseType tbt = (BaseType)e.nextElement();
                this.cAS(tbt);
            }
        } else if (bt instanceof test_SDArray) {
            ((test_SDArray)bt).cacheShape();
        }
    }

    protected GuardedDataset getDataset(ReqState rs) throws DODSException, IOException, ParseException {
        return new testDataset(rs);
    }
}

