/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.AbstractTiledRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.TileCacheRed;
import org.apache.batik.ext.awt.image.rendered.TileGenerator;
import org.apache.batik.ext.awt.image.rendered.TileStore;

public class TileRed
extends AbstractRed
implements TileGenerator {
    static final AffineTransform IDENTITY = new AffineTransform();
    Rectangle tiledRegion;
    int xStep;
    int yStep;
    TileStore tiles;
    private RenderingHints hints;
    final boolean is_INT_PACK;
    final boolean alphaPremult;
    RenderedImage tile = null;
    WritableRaster raster = null;

    public TileRed(RenderedImage tile, Rectangle tiledRegion) {
        this(tile, tiledRegion, tile.getWidth(), tile.getHeight(), null);
    }

    public TileRed(RenderedImage tile, Rectangle tiledRegion, RenderingHints hints) {
        this(tile, tiledRegion, tile.getWidth(), tile.getHeight(), hints);
    }

    public TileRed(RenderedImage tile, Rectangle tiledRegion, int xStep, int yStep) {
        this(tile, tiledRegion, xStep, yStep, null);
    }

    public TileRed(RenderedImage tile, Rectangle tiledRegion, int xStep, int yStep, RenderingHints hints) {
        if (tiledRegion == null) {
            throw new IllegalArgumentException();
        }
        if (tile == null) {
            throw new IllegalArgumentException();
        }
        this.tiledRegion = tiledRegion;
        this.xStep = xStep;
        this.yStep = yStep;
        this.hints = hints;
        this.alphaPremult = false;
        SampleModel sm = TileRed.fixSampleModel(tile, xStep, yStep, tiledRegion.width, tiledRegion.height);
        ColorModel cm = TileRed.fixColorModel(tile, this.alphaPremult);
        double smSz = AbstractTiledRed.getDefaultTileSize();
        double stepSz = (double)xStep * (double)yStep;
        if (16.1 * (smSz *= smSz) > stepSz) {
            int xSz = xStep;
            int ySz = yStep;
            if (4.0 * stepSz <= smSz) {
                int mult = (int)Math.ceil(Math.sqrt(smSz / stepSz));
                xSz *= mult;
                ySz *= mult;
            }
            sm = sm.createCompatibleSampleModel(xSz, ySz);
            this.raster = Raster.createWritableRaster(sm, new Point(tile.getMinX(), tile.getMinY()));
        }
        this.is_INT_PACK = GraphicsUtil.is_INT_PACK_Data(sm, false);
        this.init((CachableRed)null, tiledRegion, cm, sm, tile.getMinX(), tile.getMinY(), null);
        if (this.raster != null) {
            WritableRaster fromRaster = this.raster.createWritableChild(tile.getMinX(), tile.getMinY(), xStep, yStep, tile.getMinX(), tile.getMinY(), null);
            this.fillRasterFrom(fromRaster, tile);
            this.fillOutRaster(this.raster);
        } else {
            this.tile = new TileCacheRed(GraphicsUtil.wrap(tile));
        }
    }

    public WritableRaster copyData(WritableRaster wr) {
        int xOff = (int)Math.floor(wr.getMinX() / this.xStep) * this.xStep;
        int yOff = (int)Math.floor(wr.getMinY() / this.yStep) * this.yStep;
        int x0 = wr.getMinX() - xOff;
        int y0 = wr.getMinY() - yOff;
        int tx0 = this.getXTile(x0);
        int ty0 = this.getYTile(y0);
        int tx1 = this.getXTile(x0 + wr.getWidth() - 1);
        int ty1 = this.getYTile(y0 + wr.getHeight() - 1);
        int y = ty0;
        while (y <= ty1) {
            int x = tx0;
            while (x <= tx1) {
                Raster r = this.getTile(x, y);
                r = r.createChild(r.getMinX(), r.getMinY(), r.getWidth(), r.getHeight(), r.getMinX() + xOff, r.getMinY() + yOff, null);
                if (this.is_INT_PACK) {
                    GraphicsUtil.copyData_INT_PACK(r, wr);
                } else {
                    GraphicsUtil.copyData_FALLBACK(r, wr);
                }
                ++x;
            }
            ++y;
        }
        return wr;
    }

    public Raster getTile(int x, int y) {
        if (this.raster != null) {
            int tx = this.tileGridXOff + x * this.tileWidth;
            int ty = this.tileGridYOff + y * this.tileHeight;
            return this.raster.createTranslatedChild(tx, ty);
        }
        return this.genTile(x, y);
    }

    public Raster genTile(int x, int y) {
        int tx = this.tileGridXOff + x * this.tileWidth;
        int ty = this.tileGridYOff + y * this.tileHeight;
        if (this.raster != null) {
            return this.raster.createTranslatedChild(tx, ty);
        }
        Point pt = new Point(tx, ty);
        WritableRaster wr = Raster.createWritableRaster(this.sm, pt);
        this.fillRasterFrom(wr, this.tile);
        return wr;
    }

    /*
     * Unable to fully structure code
     */
    public WritableRaster fillRasterFrom(WritableRaster wr, RenderedImage src) {
        cm = this.getColorModel();
        bi = new BufferedImage(cm, wr.createWritableTranslatedChild(0, 0), cm.isAlphaPremultiplied(), null);
        g = GraphicsUtil.createGraphics(bi, this.hints);
        minX = wr.getMinX();
        minY = wr.getMinY();
        maxX = wr.getWidth();
        maxY = wr.getHeight();
        g.setComposite(AlphaComposite.Clear);
        g.setColor(new Color(0, 0, 0, 0));
        g.fillRect(0, 0, maxX, maxY);
        g.setComposite(AlphaComposite.SrcOver);
        g.translate(-minX, -minY);
        x1 = src.getMinX() + src.getWidth() - 1;
        y1 = src.getMinY() + src.getHeight() - 1;
        tileTx = (int)Math.ceil((minX - x1) / this.xStep) * this.xStep;
        tileTy = (int)Math.ceil((minY - y1) / this.yStep) * this.yStep;
        g.translate(tileTx, tileTy);
        curX = tileTx - wr.getMinX() + src.getMinX();
        curY = tileTy - wr.getMinY() + src.getMinY();
        minX = curX;
        ** GOTO lbl32
        {
            GraphicsUtil.drawImage(g, src);
            curX += this.xStep;
            g.translate(this.xStep, 0);
            if (Thread.currentThread().isInterrupted()) {
                return wr;
            }
            do {
                if (curX < maxX) continue block0;
                curY += this.yStep;
                g.translate(minX - curX, this.yStep);
                curX = minX;
lbl32:
                // 2 sources

            } while (curY < maxY);
        }
        GraphicsUtil.coerceData(wr, src.getColorModel(), this.alphaPremult);
        return wr;
    }

    protected void fillOutRaster(WritableRaster wr) {
        if (this.is_INT_PACK) {
            this.fillOutRaster_INT_PACK(wr);
        } else {
            this.fillOutRaster_FALLBACK(wr);
        }
    }

    protected void fillOutRaster_INT_PACK(WritableRaster wr) {
        int dstSP;
        int x0 = wr.getMinX();
        int y0 = wr.getMinY();
        int width = wr.getWidth();
        int height = wr.getHeight();
        SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)wr.getSampleModel();
        int scanStride = sppsm.getScanlineStride();
        DataBufferInt db = (DataBufferInt)wr.getDataBuffer();
        int[] pixels = db.getBankData()[0];
        int base = db.getOffset() + sppsm.getOffset(x0 - wr.getSampleModelTranslateX(), y0 - wr.getSampleModelTranslateY());
        int step = this.xStep;
        int x = this.xStep;
        while (x < width) {
            int y;
            int srcSP;
            int w = step;
            if (x + w > width) {
                w = width - x;
            }
            if (w >= 128) {
                srcSP = base;
                dstSP = base + x;
                y = 0;
                while (y < this.yStep) {
                    System.arraycopy(pixels, srcSP, pixels, dstSP, w);
                    srcSP += scanStride;
                    dstSP += scanStride;
                    ++y;
                }
            } else {
                srcSP = base;
                dstSP = base + x;
                y = 0;
                while (y < this.yStep) {
                    int end = srcSP;
                    srcSP += w - 1;
                    dstSP += w - 1;
                    while (srcSP >= end) {
                        pixels[dstSP--] = pixels[srcSP--];
                    }
                    srcSP += scanStride + 1;
                    dstSP += scanStride + 1;
                    ++y;
                }
            }
            x += step;
            step *= 2;
        }
        step = this.yStep;
        int y = this.yStep;
        while (y < height) {
            int h = step;
            if (y + h > height) {
                h = height - y;
            }
            dstSP = base + y * scanStride;
            System.arraycopy(pixels, base, pixels, dstSP, h * scanStride);
            y += step;
            step *= 2;
        }
    }

    protected void fillOutRaster_FALLBACK(WritableRaster wr) {
        int width = wr.getWidth();
        int height = wr.getHeight();
        Object data = null;
        int step = this.xStep;
        int x = this.xStep;
        while (x < width) {
            int w = step;
            if (x + w > width) {
                w = width - x;
            }
            data = wr.getDataElements(0, 0, w, this.yStep, data);
            wr.setDataElements(x, 0, w, this.yStep, data);
            if ((x += w) >= width) break;
            if (x + w > width) {
                w = width - x;
            }
            wr.setDataElements(x, 0, w, this.yStep, data);
            if ((x += w) >= width) break;
            if (x + w > width) {
                w = width - x;
            }
            wr.setDataElements(x, 0, w, this.yStep, data);
            x += step;
            step *= 4;
        }
        step = this.yStep;
        int y = this.yStep;
        while (y < height) {
            int h = step;
            if (y + h > height) {
                h = height - y;
            }
            data = wr.getDataElements(0, 0, width, h, data);
            wr.setDataElements(0, y, width, h, data);
            y += h;
            if (h >= height) break;
            if (y + h > height) {
                h = height - y;
            }
            wr.setDataElements(0, y, width, h, data);
            y += h;
            if (h >= height) break;
            if (y + h > height) {
                h = height - y;
            }
            wr.setDataElements(0, y, width, h, data);
            y += h;
            y += step;
            step *= 4;
        }
    }

    protected static ColorModel fixColorModel(RenderedImage src, boolean alphaPremult) {
        return GraphicsUtil.coerceColorModel(src.getColorModel(), alphaPremult);
    }

    protected static SampleModel fixSampleModel(RenderedImage src, int stepX, int stepY, int width, int height) {
        int h;
        int defSz = AbstractTiledRed.getDefaultTileSize();
        SampleModel sm = src.getSampleModel();
        int w = sm.getWidth();
        if (w < defSz) {
            w = defSz;
        }
        if (w > stepX) {
            w = stepX;
        }
        if ((h = sm.getHeight()) < defSz) {
            h = defSz;
        }
        if (h > stepY) {
            h = stepY;
        }
        return sm.createCompatibleSampleModel(w, h);
    }
}

