/*
 * Decompiled with CFR 0.152.
 */
package org.das2.sdi;

import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.dsops.Ops;
import sdi.data.SimpleContiguousBinnedData1D;

class SimpleContiguousBinnedData1DImpl
implements SimpleContiguousBinnedData1D {
    QDataSet xlow;
    QDataSet xhigh;
    QDataSet x;
    QDataSet y;

    public SimpleContiguousBinnedData1DImpl(QDataSet xlow, QDataSet xhigh, QDataSet y) {
        this.y = y;
        if (y.rank() != 1) {
            throw new IllegalArgumentException("source y is not rank 1: " + y);
        }
        if (xlow.rank() != 1) {
            throw new IllegalArgumentException("source xlow is not rank 1: " + xlow);
        }
        if (xhigh.rank() == 1) {
            this.xhigh = xhigh.slice(xhigh.length() - 1);
        } else if (xhigh.rank() == 0) {
            this.xhigh = xhigh;
        } else {
            throw new IllegalArgumentException("source xhigh must be rank 0 or rank 1");
        }
        this.xlow = xlow;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SimpleContiguousBinnedData1DImpl(QDataSet ds) {
        this.y = ds;
        QDataSet bins = SemanticOps.xtagsDataSet((QDataSet)ds);
        if (bins.rank() == 2 && bins.property("BINS_1").equals("min,max")) {
            this.xlow = Ops.slice1((QDataSet)bins, (int)0);
            this.xhigh = bins.slice(bins.length() - 1).slice(1);
            this.x = Ops.reduceMean((QDataSet)bins, (int)1);
            return;
        } else {
            if (bins.rank() != 1) return;
            this.x = bins;
            if ((QDataSet)bins.property("BIN_MINUS") == null || (QDataSet)bins.property("BIN_PLUS") == null) {
                QDataSet cadence = DataSetUtil.guessCadence((QDataSet)bins, null);
                if (cadence == null) throw new IllegalArgumentException("source x must have BIN_PLUS and BIN_MINUS");
                cadence = Ops.divide((Object)cadence, (Object)2);
                this.xlow = Ops.subtract((QDataSet)this.x, (QDataSet)cadence);
                this.xhigh = Ops.add((QDataSet)this.x, (QDataSet)cadence);
                return;
            } else {
                this.xlow = Ops.subtract((Object)this.x, (Object)bins.property("BIN_MINUS"));
                this.xhigh = Ops.add((Object)this.x, (Object)bins.property("BIN_PLUS"));
            }
        }
    }

    public int size() {
        return this.x.length();
    }

    public double getXBinLo(int i) {
        return this.xlow.value(i);
    }

    public double getXBinReference(int i) {
        return this.x.value(i);
    }

    public double getLastXBinHi() {
        return this.xhigh.value();
    }

    public double getY(int i) {
        return this.y.value(i);
    }
}

