/*
 * Decompiled with CFR 0.152.
 */
package org.das2.sdi;

import java.util.Optional;
import sdi.data.Bin;
import sdi.data.BinnedData1D;
import sdi.data.BinnedData2D;
import sdi.data.FillDetector;
import sdi.data.FillDetector2D;
import sdi.data.UncertaintyProvider;
import sdi.data.UncertaintyProvider2D;
import sdi.data.Units;
import sdi.data.XYMetadata;
import sdi.data.XYZMetadata;

public class Operations {
    public static XYMetadata sliceMetadataOnX(final XYZMetadata meta) {
        return new XYMetadata(){

            public Units getXUnits() {
                return meta.getYUnits();
            }

            public Units getYUnits() {
                return meta.getZUnits();
            }

            public String getXName() {
                return meta.getYName();
            }

            public String getYName() {
                return meta.getZName();
            }

            public String getXLabel() {
                return meta.getYLabel();
            }

            public String getYLabel() {
                return meta.getZLabel();
            }

            public String getName() {
                return meta.getName();
            }
        };
    }

    public static XYMetadata sliceMetadataOnY(final XYZMetadata meta) {
        return new XYMetadata(){

            public Units getXUnits() {
                return meta.getXUnits();
            }

            public Units getYUnits() {
                return meta.getZUnits();
            }

            public String getXName() {
                return meta.getXName();
            }

            public String getYName() {
                return meta.getZName();
            }

            public String getXLabel() {
                return meta.getXLabel();
            }

            public String getYLabel() {
                return meta.getZLabel();
            }

            public String getName() {
                return meta.getName();
            }
        };
    }

    public static Optional<FillDetector> sliceFillDetectorAtX(Optional<FillDetector2D> ofill, int iSlice) {
        if (ofill.isPresent()) {
            FillDetector2D fillDetector1 = ofill.get();
            return Optional.of(i -> fillDetector1.isFill(iSlice, i));
        }
        return Optional.empty();
    }

    public static Optional<UncertaintyProvider> sliceUncertAtX(Optional<UncertaintyProvider2D> uncert, final int iSlice) {
        if (uncert.isPresent()) {
            final UncertaintyProvider2D uncert1 = uncert.get();
            return Optional.of(new UncertaintyProvider(){

                public double getUncertPlus(int i) {
                    return uncert1.getUncertPlus(iSlice, i);
                }

                public double getUncertMinus(int i) {
                    return uncert1.getUncertMinus(iSlice, i);
                }
            });
        }
        return Optional.empty();
    }

    public static BinnedData1D sliceAtX(final BinnedData2D ds, final int iSlice) {
        return new BinnedData1D(){

            public Optional<FillDetector> getFillDetector() {
                return Operations.sliceFillDetectorAtX(ds.getFillDetector(), iSlice);
            }

            public Optional<UncertaintyProvider> getYUncertProvider() {
                return Operations.sliceUncertAtX(ds.getZUncertProvider(), iSlice);
            }

            public XYMetadata getMetadata() {
                return Operations.sliceMetadataOnX(ds.getMetadata());
            }

            public int size() {
                return ds.sizeY();
            }

            public Bin getXBin(int i) {
                return ds.getYBin(i);
            }

            public double getY(int i) {
                return ds.getZ(iSlice, i);
            }
        };
    }
}

