/*
 * Decompiled with CFR 0.152.
 */
package sdi.data;

import sdi.data.Bin;
import sdi.data.ContiguousBinnedData1D;
import sdi.data.SimpleContiguousBinnedData1D;

public class Validator {
    private Validator() {
    }

    public static void checkValid(SimpleContiguousBinnedData1D d) {
        int i;
        int n = d.size();
        for (i = 0; i < n - 1; ++i) {
            if (!(d.getXBinLo(i) >= d.getXBinLo(i + 1))) continue;
            throw new IllegalArgumentException("bad bin");
        }
        if (d.getXBinLo(n - 1) >= d.getLastXBinHi()) {
            throw new IllegalArgumentException("bad last bin");
        }
        for (i = 0; i < n - 1; ++i) {
            double r = d.getXBinReference(i);
            if (r == d.getXBinReference(i + 1)) {
                throw new IllegalArgumentException("duplicate ref");
            }
            if (!(r < d.getXBinLo(i)) && !(r > d.getXBinLo(i + 1))) continue;
            throw new IllegalArgumentException("bad ref");
        }
        double r = d.getXBinReference(n - 1);
        if (r < d.getXBinLo(n - 1) || r > d.getLastXBinHi()) {
            throw new IllegalArgumentException("bad last ref");
        }
    }

    public static void checkValid(ContiguousBinnedData1D d) {
        Validator.checkValid((SimpleContiguousBinnedData1D)d);
        d.getFillDetector();
    }

    public static void checkValid(Bin d) {
        if (d.getMin() > d.getReference()) {
            throw new IllegalArgumentException("reference must be greater than or equal to min");
        }
        if (d.getMax() < d.getReference()) {
            throw new IllegalArgumentException("reference must be less than or equal to max");
        }
    }

    public static boolean isValid(ContiguousBinnedData1D d) {
        try {
            Validator.checkValid(d);
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }
}

