/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.pds.tools.util;

import gov.nasa.arc.pds.tools.util.FileUtils;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LocaleUtils {
    public static final String DEFAULT_LOCALE_KEY = "en_US";
    public static final String DEFAULT_LANGUAGE = "en";
    public static final Locale DEFAULT_LOCALE = new Locale("en_US");
    public static final String DEFAULT_BUNDLE_ROOT = "resources";
    public static final boolean DEFAULT_DEV_MODE = false;
    private Locale locale;
    public ResourceBundle bundle;
    private Boolean devMode = false;
    public static final Pattern LOCALE_PATTERN = Pattern.compile("(\\w{2})(_(\\w{2}))?(_(\\w+))?");
    public static final String NUMERIC_FORMAT = "{0,number,integer}";
    public static final Map<Set<Object>, ResourceBundle> BUNDLE_CACHE = new HashMap<Set<Object>, ResourceBundle>();

    public LocaleUtils() {
        this(null, null, DEFAULT_BUNDLE_ROOT);
    }

    public LocaleUtils(Locale locale) {
        this(locale, (Boolean)false, DEFAULT_BUNDLE_ROOT);
    }

    public LocaleUtils(Boolean devMode) {
        this(null, devMode, DEFAULT_BUNDLE_ROOT);
    }

    public LocaleUtils(String bundleRoot) {
        this(null, (Boolean)false, bundleRoot);
    }

    public LocaleUtils(ResourceBundle bundle) {
        this(bundle.getLocale(), (Boolean)false, bundle);
    }

    public LocaleUtils(Locale locale, Boolean devMode) {
        this(locale, devMode, DEFAULT_BUNDLE_ROOT);
    }

    public LocaleUtils(Locale locale, String bundleRoot) {
        this(locale, (Boolean)false, bundleRoot);
    }

    public LocaleUtils(Locale locale, ResourceBundle bundle) {
        this(locale, (Boolean)false, bundle);
    }

    public LocaleUtils(Locale locale, Boolean devMode, String bundleRoot) {
        this.setLocale(locale);
        this.setDevMode(devMode);
        this.bundle = ResourceBundle.getBundle(bundleRoot, this.locale);
    }

    public LocaleUtils(Locale locale, Boolean devMode, ResourceBundle bundle) {
        this.setLocale(locale);
        this.setDevMode(devMode);
        this.bundle = bundle;
    }

    protected void setLocale(Locale locale) {
        this.locale = locale == null ? DEFAULT_LOCALE : locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected void setDevMode(Boolean devMode) {
        if (devMode != null) {
            this.devMode = devMode;
        }
    }

    public boolean isDevMode() {
        return this.devMode;
    }

    protected void setBundle(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    protected void setBundleName(String bundleName) {
        this.bundle = ResourceBundle.getBundle(bundleName, this.locale);
    }

    public static boolean isValidLocale(Locale locale) {
        Locale[] availLocales;
        for (Locale testLocale : availLocales = Locale.getAvailableLocales()) {
            if (!testLocale.equals(locale)) continue;
            return true;
        }
        return false;
    }

    public static Locale stringToLocale(String localeName) {
        String language = null;
        String country = null;
        String variant = null;
        Locale locale = null;
        Matcher matcher = LOCALE_PATTERN.matcher(localeName);
        if (!matcher.matches()) {
            throw new RuntimeException("Invalid locale name. The form must be LL[_CC][_VVV] where LL = 2 char language code, CC is an optional 2 char country code and VVV is an optional N character variant.");
        }
        language = matcher.group(1);
        country = matcher.group(3);
        variant = matcher.group(5);
        if (variant != null) {
            locale = new Locale(language, country, variant);
        } else if (country != null) {
            locale = new Locale(language, country);
        } else if (language != null) {
            locale = new Locale(language);
        }
        return locale;
    }

    public static String localeToString(Locale locale) {
        return locale.toString();
    }

    public String getText(String key, Object ... arguments) {
        return this.getText(key, this.getBundle(), arguments);
    }

    private String getText(String key, ResourceBundle bundle, Object ... arguments) {
        if (key == null) {
            return null;
        }
        String message = null;
        try {
            message = bundle.getString(key);
        }
        catch (MissingResourceException e) {
            if (this.devMode.booleanValue()) {
                throw new RuntimeException("Unable to find message for key \"" + key + "\".");
            }
            return key;
        }
        return this.formatText(message, arguments);
    }

    public String formatText(String message, Object ... arguments) {
        Object[] args = null;
        args = arguments != null && arguments.length == 1 && arguments[0] instanceof List ? ((List)arguments[0]).toArray() : arguments;
        MessageFormat format = new MessageFormat(message, this.locale);
        return format.format(args);
    }

    public String getNumber(Number number) {
        return this.formatText(NUMERIC_FORMAT, number);
    }

    public String formatBytes(double memory) {
        return this.formatBytes(memory, null);
    }

    public String formatBytes(double memory, Locale override) {
        String result = "";
        Locale curLocale = override != null ? override : this.locale;
        NumberFormat format = NumberFormat.getInstance(curLocale);
        double value = memory;
        result = value < 0.9 * (double)FileUtils.ONE_KB ? format.format(value) + " B" : (value < 0.9 * (double)FileUtils.ONE_MB ? format.format(value / (double)FileUtils.ONE_KB) + " KB" : (value < 0.9 * (double)FileUtils.ONE_GB ? format.format(value / (double)FileUtils.ONE_MB) + " MB" : (value < 0.9 * (double)FileUtils.ONE_TB ? format.format(value / (double)FileUtils.ONE_GB) + " GB" : (value < 0.9 * (double)FileUtils.ONE_PB ? format.format(value / (double)FileUtils.ONE_TB) + " TB" : format.format(value / (double)FileUtils.ONE_PB) + " PB"))));
        return result;
    }
}

