/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import gnu.regexp.REMatch;
import gnu.regexp.REToken;

final class RETokenRange
extends REToken {
    private char lo;
    private char hi;
    private boolean insens;

    RETokenRange(int subIndex, char lo, char hi, boolean ins) {
        super(subIndex);
        this.insens = ins;
        this.lo = this.insens ? Character.toLowerCase(lo) : lo;
        this.hi = ins ? Character.toLowerCase(hi) : hi;
    }

    int getMinimumLength() {
        return 1;
    }

    boolean match(CharIndexed input, REMatch mymatch) {
        char c = input.charAt(mymatch.index);
        if (c == '\uffff') {
            return false;
        }
        if (this.insens) {
            c = Character.toLowerCase(c);
        }
        if (c >= this.lo && c <= this.hi) {
            ++mymatch.index;
            return this.next(input, mymatch);
        }
        return false;
    }

    void dump(StringBuffer os) {
        os.append(this.lo).append('-').append(this.hi);
    }
}

