/*
 * Decompiled with CFR 0.152.
 */
package dods.servlet.jake;

import dods.dap.DAS;
import dods.dap.DConnect;
import dods.dap.DDS;
import dods.dap.DODSException;
import dods.dap.DataDDS;
import dods.servlet.jake.DispatchServlet;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ProxyServlet
extends DispatchServlet {
    public void getDAS(HttpServletRequest req, HttpServletResponse res, String path, String ce) throws ServletException, IOException {
        ServletOutputStream out = res.getOutputStream();
        try {
            DConnect con = this.proxyConnect(path, ce);
            DAS das = con.getDAS();
            das.print((OutputStream)out);
        }
        catch (DODSException e) {
            res.setHeader("Content-Description", "dods_error");
            e.print((OutputStream)out);
        }
        catch (Exception e) {
            res.setHeader("Content-Description", "dods_error");
            DODSException de = new DODSException(0, e.getMessage());
            de.print((OutputStream)out);
        }
    }

    public void getDDS(HttpServletRequest req, HttpServletResponse res, String path, String ce) throws ServletException, IOException {
        ServletOutputStream out = res.getOutputStream();
        try {
            DConnect con = this.proxyConnect(path, ce);
            DDS dds = con.getDDS();
            dds.print((OutputStream)out);
        }
        catch (DODSException e) {
            res.setHeader("Content-Description", "dods_error");
            e.print((OutputStream)out);
        }
        catch (Exception e) {
            res.setHeader("Content-Description", "dods_error");
            DODSException de = new DODSException(0, e.getMessage());
            de.print((OutputStream)out);
        }
    }

    public void getData(HttpServletRequest req, HttpServletResponse res, String path, String ce, boolean compress) throws ServletException, IOException {
        ServletOutputStream out = res.getOutputStream();
        try {
            DConnect con = this.proxyConnect(path, ce);
            DataDDS dds = con.getData(null);
            dds.externalize((OutputStream)out, compress, false);
        }
        catch (DODSException e) {
            res.setContentType("text/plain");
            res.setHeader("Content-Description", "dods_error");
            res.setHeader("Content-Encoding", "none");
            e.print((OutputStream)out);
        }
        catch (Exception e) {
            res.setHeader("Content-Description", "dods_error");
            DODSException de = new DODSException(0, e.getMessage());
            de.print((OutputStream)out);
        }
    }

    private DConnect proxyConnect(String path, String ce) throws DODSException {
        int secondSlashIndex = path.indexOf(47, 1);
        String server = path.substring(1, secondSlashIndex);
        String newPath = path.substring(secondSlashIndex);
        Enumeration names = this.getInitParameterNames();
        while (names.hasMoreElements()) {
            String paramName = (String)names.nextElement();
            if (!paramName.equals(server)) continue;
            String url = this.getInitParameter(paramName) + newPath + "?" + ce;
            try {
                DConnect con = new DConnect(url, true);
                return con;
            }
            catch (FileNotFoundException e) {
                throw new DODSException(1, "file not found: " + url);
            }
        }
        throw new DODSException(1, "proxy path not found: " + path);
    }
}

