/*
 * Decompiled with CFR 0.152.
 */
package proguard.retrace;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import proguard.obfuscate.MappingProcessor;
import proguard.retrace.StackTraceItem;

final class StackTrace
implements MappingProcessor {
    private final boolean verbose;
    private final List stackTraceItems = new ArrayList();

    public StackTrace(boolean bl) {
        this.verbose = bl;
    }

    public void read(File file) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            String string;
            Reader reader = file == null ? new InputStreamReader(System.in) : new BufferedReader(new FileReader(file));
            bufferedReader = new LineNumberReader(reader);
            while ((string = ((LineNumberReader)bufferedReader).readLine()) != null) {
                if ((string = string.trim()).length() == 0) continue;
                StackTraceItem stackTraceItem = new StackTraceItem(this.verbose);
                stackTraceItem.parse(string);
                this.stackTraceItems.add(stackTraceItem);
            }
        }
        catch (IOException iOException) {
            throw new IOException("Can't read stack trace (" + iOException.getMessage() + ")");
        }
        finally {
            if (file != null && bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void print() {
        for (int i = 0; i < this.stackTraceItems.size(); ++i) {
            StackTraceItem stackTraceItem = (StackTraceItem)this.stackTraceItems.get(i);
            stackTraceItem.print();
        }
    }

    @Override
    public boolean processClassMapping(String string, String string2) {
        boolean bl = false;
        for (int i = 0; i < this.stackTraceItems.size(); ++i) {
            StackTraceItem stackTraceItem = (StackTraceItem)this.stackTraceItems.get(i);
            bl |= stackTraceItem.processClassMapping(string, string2);
        }
        return bl;
    }

    @Override
    public void processFieldMapping(String string, String string2, String string3, String string4) {
    }

    @Override
    public void processMethodMapping(String string, int n, int n2, String string2, String string3, String string4) {
        for (int i = 0; i < this.stackTraceItems.size(); ++i) {
            StackTraceItem stackTraceItem = (StackTraceItem)this.stackTraceItems.get(i);
            stackTraceItem.processMethodMapping(string, n, n2, string2, string3, string4);
        }
    }
}

