/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.objectAccess;

import gov.nasa.arc.pds.xml.generated.FileAreaObservational;
import gov.nasa.arc.pds.xml.generated.ProductObservational;
import gov.nasa.pds.objectAccess.ObjectAccess;
import gov.nasa.pds.objectAccess.ObjectProvider;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ObjectExporter {
    Logger logger = LoggerFactory.getLogger(ObjectExporter.class);
    private ObjectProvider objectProvider;
    private FileAreaObservational fileArea;

    public ObjectExporter() {
        this.objectProvider = null;
        this.fileArea = null;
    }

    public ObjectExporter(File label, int fileAreaIndex) throws Exception {
        this(label.toURI().toURL(), fileAreaIndex);
    }

    public ObjectExporter(URL label, int fileAreaIndex) throws Exception {
        this.parseLabel(label, fileAreaIndex);
    }

    public ObjectExporter(FileAreaObservational fileArea, ObjectProvider provider) throws IOException {
        this.objectProvider = provider;
        this.fileArea = fileArea;
    }

    protected void parseLabel(File label, int fileAreaIndex) throws Exception {
        this.parseLabel(label.toURI().toURL(), fileAreaIndex);
    }

    protected void parseLabel(URL label, int fileAreaIndex) throws Exception {
        boolean canRead = true;
        try {
            label.openStream().close();
        }
        catch (IOException io) {
            canRead = false;
        }
        if (canRead) {
            URI labelUri = label.toURI().normalize();
            URL parentUrl = labelUri.getPath().endsWith("/") ? labelUri.resolve("..").toURL() : labelUri.resolve(".").toURL();
            this.objectProvider = new ObjectAccess(parentUrl);
            ProductObservational p = this.objectProvider.getProduct(label, ProductObservational.class);
            try {
                this.fileArea = p.getFileAreaObservationals().get(fileAreaIndex);
            }
            catch (IndexOutOfBoundsException e) {
                String message = "Label has no such ObservationalFileArea";
                this.logger.error(message);
                throw new Exception(message);
            }
        } else {
            String message = "Input file does not exist: " + label.toString();
            this.logger.error(message);
            throw new IOException(message);
        }
    }

    public void setObjectProvider(ObjectProvider provider) {
        this.objectProvider = provider;
    }

    public ObjectProvider getObjectProvider() {
        return this.objectProvider;
    }

    public void setObservationalFileArea(FileAreaObservational fileAreaObs) {
        this.fileArea = fileAreaObs;
    }

    public FileAreaObservational getObservationalFileArea() {
        return this.fileArea;
    }
}

