/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.label.object;

import gov.nasa.arc.pds.xml.generated.Array;
import gov.nasa.arc.pds.xml.generated.Array2DImage;
import gov.nasa.arc.pds.xml.generated.Array3DImage;
import gov.nasa.pds.label.object.DataObject;
import gov.nasa.pds.objectAccess.array.ArrayAdapter;
import gov.nasa.pds.objectAccess.array.ElementType;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;

public class ArrayObject
extends DataObject {
    private Array array;
    private ArrayAdapter adapter;
    private ElementType elementType;
    int[] dimensions;

    public ArrayObject(File parentDir, gov.nasa.arc.pds.xml.generated.File fileObject, Array array, long offset) throws FileNotFoundException, IOException {
        this(parentDir.toURI().toURL(), fileObject, array, offset);
    }

    public ArrayObject(URL parent, gov.nasa.arc.pds.xml.generated.File fileObject, Array array, long offset) throws FileNotFoundException, IOException {
        super(parent, fileObject, offset, 0L);
        this.array = array;
        this.dimensions = this.findDimensions();
        this.elementType = ElementType.getTypeForName(array.getElementArray().getDataType());
        this.setSize(this.findSize(this.elementType.getSize()));
        this.adapter = new ArrayAdapter(this.dimensions, this.getChannel(), this.elementType);
    }

    private int[] findDimensions() {
        int[] dims = new int[this.array.getAxes()];
        for (int i = 0; i < dims.length; ++i) {
            dims[i] = this.array.getAxisArraies().get(i).getElements().intValueExact();
        }
        return dims;
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    public String getName() {
        return this.array.getName();
    }

    private long findSize(int elementSize) {
        long count = 1L;
        for (int i = 0; i < this.dimensions.length; ++i) {
            count *= (long)this.dimensions[i];
        }
        return count * (long)elementSize;
    }

    public int getAxes() {
        return this.dimensions.length;
    }

    public int getElementSize() {
        return this.adapter.getElementSize();
    }

    public int getInt(int row, int column) throws IOException {
        return this.getInt(new int[]{row, column});
    }

    public long getLong(int row, int column) throws IOException {
        return this.getLong(new int[]{row, column});
    }

    public double getDouble(int row, int column) throws IOException {
        return this.getDouble(new int[]{row, column});
    }

    public int getInt(int i1, int i2, int i3) throws IOException {
        return this.getInt(new int[]{i1, i2, i3});
    }

    public long getLong(int i1, int i2, int i3) throws IOException {
        return this.getLong(new int[]{i1, i2, i3});
    }

    public double getDouble(int i1, int i2, int i3) throws IOException {
        return this.adapter.getDouble(i1, i2, i3);
    }

    public int getInt(int[] position) throws IOException {
        this.checkIndices(position);
        return this.adapter.getInt(position);
    }

    public long getLong(int[] position) throws IOException {
        this.checkIndices(position);
        return this.adapter.getLong(position);
    }

    public double getDouble(int[] position) throws IOException {
        this.checkIndices(position);
        return this.adapter.getDouble(position);
    }

    private void checkIndices(int[] position) {
        this.checkDimensions(position.length);
        for (int i = 0; i < this.dimensions.length; ++i) {
            if (position[i] >= 0 && position[i] < this.dimensions[i]) continue;
            throw new ArrayIndexOutOfBoundsException("Index " + i + " out of bounds (" + position[i] + ")");
        }
    }

    public double[] getElements1D() throws IOException {
        this.checkDimensions(1);
        double[] values = new double[this.dimensions[0]];
        for (int i = 0; i < this.dimensions[0]; ++i) {
            values[i] = this.getDouble(new int[]{i});
        }
        return values;
    }

    public double[][] getElements2D() throws IOException {
        this.checkDimensions(2);
        double[][] values = new double[this.dimensions[0]][this.dimensions[1]];
        for (int i = 0; i < this.dimensions[0]; ++i) {
            for (int j = 0; j < this.dimensions[1]; ++j) {
                values[i][j] = this.getDouble(i, j);
            }
        }
        return values;
    }

    public double[][][] getElements3D() throws IOException {
        this.checkDimensions(3);
        double[][][] values = new double[this.dimensions[0]][this.dimensions[1]][this.dimensions[2]];
        for (int i = 0; i < this.dimensions[0]; ++i) {
            for (int j = 0; j < this.dimensions[1]; ++j) {
                for (int k = 0; k < this.dimensions[2]; ++k) {
                    values[i][j][k] = this.getDouble(i, j, k);
                }
            }
        }
        return values;
    }

    private void checkDimensions(int expected) {
        if (expected != this.dimensions.length) {
            throw new IllegalArgumentException("Array access with wrong number of dimensions: " + expected + "!=" + this.dimensions.length);
        }
    }

    public boolean isImage() {
        return this.array instanceof Array2DImage || this.array instanceof Array3DImage;
    }

    public BufferedImage as2DImage() {
        if (!(this.array instanceof Array2DImage)) {
            throw new UnsupportedOperationException("Data object is not a 2-D image.");
        }
        BufferedImage image = new BufferedImage(this.dimensions[0], this.dimensions[1], 10);
        return image;
    }

    public ElementType getElementType() {
        return this.elementType;
    }
}

