/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.label.jaxb;

import gov.nasa.pds.label.jaxb.PDSNamespacePrefixMapper;
import gov.nasa.pds.label.jaxb.XMLLabelContext;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.EventReaderDelegate;

public class PDSXMLEventReader
extends EventReaderDelegate {
    private XMLLabelContext labelContext;
    private String root;

    public PDSXMLEventReader(XMLEventReader xsr, String root) {
        super(xsr);
        this.root = root;
        this.labelContext = new XMLLabelContext();
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        ProcessingInstruction pi;
        XMLEvent e = super.nextEvent();
        if (e.getEventType() == 1) {
            StartElement startElement = e.asStartElement();
            String name = startElement.getName().getLocalPart();
            if (name.equalsIgnoreCase(this.root)) {
                Attribute attr;
                PDSNamespacePrefixMapper namespaces = null;
                try {
                    namespaces = this.collectXmlns(startElement);
                }
                catch (IOException io) {
                    throw new XMLStreamException("Error while trying to read namespace properties file: " + io.getMessage());
                }
                if (namespaces != null) {
                    this.labelContext.setNamespaces(namespaces);
                }
                if ((attr = startElement.getAttributeByName(new QName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation"))) != null) {
                    String value = attr.getValue().trim();
                    value = value.replaceAll("\\s+", "  ");
                    this.labelContext.setSchemaLocation(value);
                }
            }
        } else if (e.getEventType() == 3 && "xml-model".equalsIgnoreCase((pi = (ProcessingInstruction)e).getTarget()) && pi.getData() != null) {
            this.labelContext.addXmlModel(pi.getData());
        }
        return e;
    }

    private PDSNamespacePrefixMapper collectXmlns(StartElement e) throws IOException {
        PDSNamespacePrefixMapper namespaces = new PDSNamespacePrefixMapper();
        NamespaceContext nsCtx = e.getNamespaceContext();
        Iterator<Namespace> i = e.getNamespaces();
        while (i.hasNext()) {
            Namespace ns = i.next();
            String uri = ns.getNamespaceURI();
            String prefix = ns.getPrefix();
            if (prefix.isEmpty()) {
                namespaces.setDefaultNamespaceURI(ns.getValue());
            }
            String value = ns.getValue();
            namespaces.addNamespaceURIMapping(prefix, value);
        }
        return namespaces;
    }

    public XMLLabelContext getLabelContext() {
        return this.labelContext;
    }
}

