/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.objectAccess;

import gov.nasa.arc.pds.xml.generated.Array;
import gov.nasa.arc.pds.xml.generated.DisciplineArea;
import gov.nasa.arc.pds.xml.generated.DisplaySettings;
import gov.nasa.arc.pds.xml.generated.FileAreaObservational;
import gov.nasa.arc.pds.xml.generated.LocalInternalReference;
import gov.nasa.arc.pds.xml.generated.ProductObservational;
import gov.nasa.pds.objectAccess.ObjectAccess;
import gov.nasa.pds.objectAccess.ObjectExporter;
import gov.nasa.pds.objectAccess.ObjectProvider;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public abstract class ImageExporter
extends ObjectExporter {
    private List<DisplaySettings> displaySettings;

    public ImageExporter(File label, String dataFile) throws Exception {
        this(label.toURI().toURL(), dataFile);
    }

    public ImageExporter(URL label, String dataFile) throws Exception {
        this.parseLabel(label, dataFile);
    }

    public ImageExporter(File label, int fileAreaIndex) throws Exception {
        this(label.toURI().toURL(), fileAreaIndex);
    }

    public ImageExporter(URL label, int fileAreaIndex) throws Exception {
        super(label, fileAreaIndex);
        if (this.displaySettings == null) {
            this.displaySettings = new ArrayList<DisplaySettings>();
        }
    }

    public ImageExporter(FileAreaObservational fileArea, ObjectProvider provider) throws IOException {
        super(fileArea, provider);
        this.displaySettings = new ArrayList<DisplaySettings>();
    }

    @Override
    protected void parseLabel(File label, int fileAreaIndex) throws Exception {
        this.parseLabel(label.toURI().toURL(), fileAreaIndex);
    }

    @Override
    protected void parseLabel(URL label, int fileAreaIndex) throws Exception {
        this.parseLabel(label, "", fileAreaIndex);
    }

    protected void parseLabel(File label, String dataFile) throws Exception {
        this.parseLabel(label.toURI().toURL(), dataFile);
    }

    protected void parseLabel(URL label, String dataFile) throws Exception {
        this.parseLabel(label, dataFile, -1);
    }

    private void parseLabel(URL label, String dataFile, int fileAreaIndex) throws Exception {
        boolean canRead = true;
        try {
            label.openStream().close();
        }
        catch (IOException io) {
            canRead = false;
        }
        if (canRead) {
            URI labelUri = label.toURI().normalize();
            URL parentUrl = labelUri.getPath().endsWith("/") ? labelUri.resolve("..").toURL() : labelUri.resolve(".").toURL();
            this.setObjectProvider(new ObjectAccess(parentUrl));
            ProductObservational p = this.getObjectProvider().getProduct(label, ProductObservational.class);
            DisciplineArea disciplineArea = null;
            try {
                disciplineArea = p.getObservationArea().getDisciplineArea();
                if (disciplineArea != null) {
                    for (Object object : disciplineArea.getAnies()) {
                        if (!(object instanceof DisplaySettings)) continue;
                        this.displaySettings.add((DisplaySettings)object);
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                String message = "Label has no such ObservationalArea";
                this.logger.error(message);
                throw new Exception(message);
            }
            if (fileAreaIndex != -1) {
                try {
                    this.setObservationalFileArea(p.getFileAreaObservationals().get(fileAreaIndex));
                }
                catch (IndexOutOfBoundsException e) {
                    String message = "Label has no such ObservationalFileArea";
                    this.logger.error(message);
                    throw new Exception(message);
                }
            } else {
                for (FileAreaObservational fao : p.getFileAreaObservationals()) {
                    if (!dataFile.equalsIgnoreCase(fao.getFile().getFileName())) continue;
                    this.setObservationalFileArea(fao);
                    break;
                }
                if (this.getObservationalFileArea() == null) {
                    String message = "Label has no such ObservationalFileArea with data file name '" + dataFile + "'.";
                    this.logger.error(message);
                    throw new Exception(message);
                }
            }
        } else {
            String message = "Input file does not exist: " + label.toString();
            this.logger.error(message);
            throw new IOException(message);
        }
    }

    public void setDisplaySettings(List<DisplaySettings> displaySettings) {
        this.displaySettings = displaySettings;
    }

    public DisplaySettings getDisplaySettings(String id) {
        for (DisplaySettings ds : this.displaySettings) {
            Array array;
            LocalInternalReference lir;
            if (ds.getLocalInternalReference() == null || (lir = ds.getLocalInternalReference()).getLocalIdentifierReference() == null || !(lir.getLocalIdentifierReference() instanceof Array) || !id.equals((array = (Array)lir.getLocalIdentifierReference()).getLocalIdentifier())) continue;
            return ds;
        }
        return null;
    }
}

