/*
 * Decompiled with CFR 0.152.
 */
package dods.util;

import dods.dap.BaseType;
import dods.dap.DArray;
import dods.dap.DArrayDimension;
import dods.dap.DByte;
import dods.dap.DDS;
import dods.dap.DFloat32;
import dods.dap.DFloat64;
import dods.dap.DGrid;
import dods.dap.DInt16;
import dods.dap.DInt32;
import dods.dap.DList;
import dods.dap.DSequence;
import dods.dap.DString;
import dods.dap.DStructure;
import dods.dap.DUInt16;
import dods.dap.DUInt32;
import dods.dap.DURL;
import dods.dap.NoSuchVariableException;
import java.util.Enumeration;

public class dasTools {
    public static boolean nameInKillFile(String name) {
        return false;
    }

    public static boolean nameInDDS(String name, DDS dds) {
        boolean found = true;
        try {
            dds.getVariable(name);
        }
        catch (NoSuchVariableException e) {
            found = false;
        }
        return found;
    }

    public static boolean nameIsGlobal(String name) {
        String lcName = name.toLowerCase();
        boolean global = false;
        if (lcName.indexOf("global") >= 0) {
            global = true;
        }
        if (lcName.indexOf("dods") >= 0) {
            global = true;
        }
        return global;
    }

    public static String fancyTypeName(BaseType bt) {
        if (bt instanceof DByte) {
            return "8 bit Byte";
        }
        if (bt instanceof DUInt16) {
            return "16 bit Unsigned Integer";
        }
        if (bt instanceof DInt16) {
            return "16 bit Integer";
        }
        if (bt instanceof DUInt32) {
            return "32 bit Unsigned Integer";
        }
        if (bt instanceof DInt32) {
            return "32 bit Integer";
        }
        if (bt instanceof DFloat32) {
            return "32 bit Real";
        }
        if (bt instanceof DFloat64) {
            return "64 bit Real";
        }
        if (bt instanceof DURL) {
            return "URL";
        }
        if (bt instanceof DString) {
            return "String";
        }
        if (bt instanceof DArray) {
            DArray a = (DArray)bt;
            String type = "Array of " + dasTools.fancyTypeName(a.getPrimitiveVector().getTemplate()) + "s ";
            Enumeration e = a.getDimensions();
            while (e.hasMoreElements()) {
                DArrayDimension dad = (DArrayDimension)e.nextElement();
                type = type + "[" + dad.getName() + " = 0.." + (dad.getSize() - 1) + "]";
            }
            type = type + "\n";
            return type;
        }
        if (bt instanceof DList) {
            DList a = (DList)bt;
            String type = "List of " + dasTools.fancyTypeName(a.getPrimitiveVector().getTemplate()) + "s\n";
            return type;
        }
        if (bt instanceof DStructure) {
            return "Structure";
        }
        if (bt instanceof DSequence) {
            return "Sequence";
        }
        if (bt instanceof DGrid) {
            return "Grid";
        }
        return "UNKNOWN";
    }
}

