/*
 * Decompiled with CFR 0.152.
 */
package dods.servlet.jake;

import dods.dap.ServerVersion;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class DispatchServlet
extends HttpServlet {
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String path = req.getPathInfo();
        String ce = req.getQueryString();
        res.setHeader("Server", ServerVersion.getCurrentVersion());
        int typeIndex = path.lastIndexOf(46);
        if (typeIndex != -1) {
            String requestType = path.substring(typeIndex + 1);
            path = path.substring(0, typeIndex);
            if (requestType.equals("das")) {
                res.setContentType("text/plain");
                res.setHeader("Content-Description", "dods_das");
                this.getDAS(req, res, path, ce);
            } else if (requestType.equals("dds")) {
                res.setContentType("text/plain");
                res.setHeader("Content-Description", "dods_dds");
                this.getDDS(req, res, path, ce);
            } else if (requestType.equals("dods")) {
                res.setContentType("application/octet-stream");
                res.setHeader("Content-Description", "dods_data");
                boolean compress = false;
                String encoding = req.getHeader("Accept-Encoding");
                if (encoding != null && encoding.equals("deflate")) {
                    compress = true;
                    res.setHeader("Content-Encoding", "deflate");
                }
                this.getData(req, res, path, ce, compress);
            } else {
                this.printURLError(res, path, ce);
            }
        } else {
            this.printURLError(res, path, ce);
        }
    }

    private void printURLError(HttpServletResponse res, String path, String ce) throws IOException {
        res.setContentType("text/html");
        ServletOutputStream out = res.getOutputStream();
        out.println("<html>");
        out.println("<head><title>Error in URL</title></head>");
        out.println("<body>");
        out.println("<h1>Error in URL</h1>");
        out.println("path = " + path);
        out.println("<br>ce = " + ce);
        out.println("</body></html>");
    }

    public abstract void getDAS(HttpServletRequest var1, HttpServletResponse var2, String var3, String var4) throws ServletException, IOException;

    public abstract void getDDS(HttpServletRequest var1, HttpServletResponse var2, String var3, String var4) throws ServletException, IOException;

    public abstract void getData(HttpServletRequest var1, HttpServletResponse var2, String var3, String var4, boolean var5) throws ServletException, IOException;
}

