/*
 * Decompiled with CFR 0.152.
 */
package dods.servlet;

import dods.dap.BaseType;
import dods.dap.DConnect;
import dods.dap.DODSException;
import dods.dap.DataDDS;
import dods.dap.parser.ParseException;
import dods.servers.ascii.asciiFactory;
import dods.servers.ascii.toASCII;
import dods.servlet.ReqState;
import dods.util.Debug;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class dodsASCII {
    private static final boolean _Debug = false;

    public void sendASCII(HttpServletRequest request, HttpServletResponse response, ReqState rs) throws DODSException, ParseException {
        if (Debug.isSet("showResponse")) {
            System.out.println("Sending DODS ASCII Data For: " + rs.getDataSet() + "    CE: '" + request.getQueryString() + "'");
        }
        String ce = request.getQueryString() == null ? "" : "?" + request.getQueryString();
        int suffixIndex = request.getRequestURL().toString().lastIndexOf(".");
        String requestURL = request.getRequestURL().substring(0, suffixIndex);
        if (Debug.isSet("showResponse")) {
            System.out.println("New Request URL Resource: '" + requestURL + "'");
            System.out.println("New Request Constraint Expression: '" + ce + "'");
        }
        try {
            DConnect url = new DConnect(requestURL, true);
            DataDDS dds = url.getData(ce, null, new asciiFactory());
            PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());
            PrintWriter pwDebug = new PrintWriter(System.out);
            dds.print(pw);
            pw.println("---------------------------------------------");
            Enumeration e = dds.getVariables();
            while (e.hasMoreElements()) {
                BaseType bt = (BaseType)e.nextElement();
                ((toASCII)((Object)bt)).toASCII(pw, true, null, true);
            }
            pw.flush();
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("OUCH! FileNotFoundException: " + fnfe.getMessage());
            fnfe.printStackTrace(System.out);
        }
        catch (MalformedURLException mue) {
            System.out.println("OUCH! MalformedURLException: " + mue.getMessage());
            mue.printStackTrace(System.out);
        }
        catch (IOException ioe) {
            System.out.println("OUCH! IOException: " + ioe.getMessage());
            ioe.printStackTrace(System.out);
        }
    }
}

