/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.python.compiler.ClassConstants;
import org.python.compiler.Code;
import org.python.compiler.ProxyMaker;
import org.python.core.PyObject;

public class JavaMaker
extends ProxyMaker
implements ClassConstants {
    public String pythonClass;
    public String pythonModule;
    public String[] properties;
    public String[] packages;
    PyObject methods;
    public boolean frozen;
    public boolean main;

    public JavaMaker(Class superclass, Class[] interfaces, String pythonClass, String pythonModule, String myClass, PyObject methods) {
        this(superclass, interfaces, pythonClass, pythonModule, myClass, null, null, methods, false, false);
    }

    public JavaMaker(Class superclass, Class[] interfaces, String pythonClass, String pythonModule, String myClass, String[] packages, String[] properties, PyObject methods, boolean frozen, boolean main) {
        super(myClass, superclass, interfaces);
        this.pythonClass = pythonClass;
        this.pythonModule = pythonModule;
        this.packages = packages;
        this.properties = properties;
        this.frozen = frozen;
        this.main = main;
        this.methods = methods;
    }

    private void makeStrings(Code code, String[] list) throws Exception {
        if (list != null) {
            int n = list.length;
            code.iconst(n);
            code.anewarray(code.pool.Class("java/lang/String"));
            int strings = code.getLocal("[java/lang/String");
            code.astore(strings);
            for (int i = 0; i < n; ++i) {
                code.aload(strings);
                code.iconst(i);
                code.ldc(list[i]);
                code.aastore();
            }
            code.aload(strings);
            code.freeLocal(strings);
        } else {
            code.aconst_null();
        }
    }

    public void addConstructor(String name, Class[] parameters, Class ret, String sig, int access) throws Exception {
        Code code = this.classfile.addMethod("<init>", sig, access);
        this.callSuper(code, "<init>", name, parameters, null, sig);
        code.aload(0);
        this.getArgs(code, parameters);
        int initProxy = code.pool.Methodref(this.classfile.name, "__initProxy__", "([Ljava/lang/Object;)V");
        code.invokevirtual(initProxy);
        code.return_();
    }

    public void addProxy() throws Exception {
        if (this.methods != null) {
            super.addProxy();
        }
        Code code = this.classfile.addMethod("__initProxy__", "([Ljava/lang/Object;)V", 1);
        code.aload(0);
        code.ldc(this.pythonModule);
        code.ldc(this.pythonClass);
        code.aload(1);
        this.makeStrings(code, this.packages);
        this.makeStrings(code, this.properties);
        code.iconst(this.frozen ? 1 : 0);
        int initProxy = code.pool.Methodref("org/python/core/Py", "initProxy", "(Lorg/python/core/PyProxy;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;[Ljava/lang/String;[Ljava/lang/String;Z)V");
        code.invokestatic(initProxy);
        code.return_();
        if (this.main) {
            this.addMain();
        }
    }

    public void addMethod(Method method, int access) throws Exception {
        if (Modifier.isAbstract(access)) {
            super.addMethod(method, access);
        } else if (this.methods.__finditem__(method.getName().intern()) != null) {
            super.addMethod(method, access);
        } else if (Modifier.isProtected(method.getModifiers())) {
            this.addSuperMethod(method, access);
        }
    }

    public void addMain() throws Exception {
        Code code = this.classfile.addMethod("main", "(Ljava/lang/String;)V", 9);
        int forname = code.pool.Methodref("java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
        code.ldc(this.pythonModule);
        code.invokestatic(forname);
        code.aload(0);
        this.makeStrings(code, this.packages);
        this.makeStrings(code, this.properties);
        code.iconst(this.frozen ? 1 : 0);
        int runMain = code.pool.Methodref("org/python/core/Py", "runMain", "(Ljava/lang/Class;[Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;Z)V");
        code.invokestatic(runMain);
        code.return_();
    }
}

