/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;
import java.util.Vector;
import org.python.compiler.Attribute;
import org.python.compiler.ClassFile;
import org.python.compiler.ConstantPool;
import org.python.compiler.ExceptionLabel;
import org.python.compiler.Label;
import org.python.compiler.LineNumberTable;

public class Code
extends Attribute {
    ConstantPool pool;
    public int stack;
    int max_stack;
    public DataOutputStream code;
    ByteArrayOutputStream stream;
    String sig;
    String[] locals;
    int nlocals;
    int argcount;
    int att_name;
    Vector labels;
    Vector exceptions;
    LineNumberTable linenumbers;
    int returnLocal;
    BitSet finallyLocals = new BitSet();

    public Label getLabel() {
        Label l = new Label(this);
        this.addLabel(l);
        return l;
    }

    public Label getLabelAtPosition() {
        Label l = this.getLabel();
        l.setPosition();
        return l;
    }

    public void addLabel(Label l) {
        this.labels.addElement(l);
    }

    public int size() {
        return this.stream.size();
    }

    public Code(String sig, ConstantPool pool, boolean isStatic) {
        this.sig = sig;
        this.max_stack = 2;
        this.stack = 0;
        this.pool = pool;
        this.stream = new ByteArrayOutputStream();
        this.code = new DataOutputStream(this.stream);
        this.nlocals = -ConstantPool.sigSize(sig, false);
        if (!isStatic) {
            ++this.nlocals;
        }
        this.argcount = this.nlocals;
        this.locals = new String[this.nlocals + 128];
        this.labels = new Vector();
        this.exceptions = new Vector();
        try {
            this.att_name = pool.UTF8("Code");
        }
        catch (IOException e) {
            this.att_name = 0;
        }
    }

    public int getLocal(String type) {
        for (int l = this.argcount; l < this.nlocals; ++l) {
            if (this.locals[l] != null) continue;
            this.locals[l] = type;
            return l;
        }
        if (this.nlocals >= this.locals.length) {
            String[] new_locals = new String[this.locals.length * 2];
            System.arraycopy(this.locals, 0, new_locals, 0, this.locals.length);
            this.locals = new_locals;
        }
        this.locals[this.nlocals] = type;
        ++this.nlocals;
        return this.nlocals - 1;
    }

    public void freeLocal(int l) {
        if (this.locals[l] == null) {
            System.out.println("Double free:" + l);
        }
        this.locals[l] = null;
    }

    public int getFinallyLocal(String type) {
        int l = this.getLocal(type);
        this.finallyLocals.set(l);
        return l;
    }

    public void freeFinallyLocal(int l) {
        this.finallyLocals.clear(l);
        this.freeLocal(l);
    }

    public int getReturnLocal() {
        if (this.returnLocal == 0) {
            this.returnLocal = this.getLocal("return");
        }
        return this.returnLocal;
    }

    public Vector getActiveLocals() {
        Vector<String> ret = new Vector<String>();
        ret.setSize(this.nlocals);
        for (int l = this.argcount; l < this.nlocals; ++l) {
            if (l == this.returnLocal || this.finallyLocals.get(l)) continue;
            ret.setElementAt(this.locals[l], l);
        }
        return ret;
    }

    public void addExceptionHandler(Label begin, Label end, Label handler, int exc) {
        this.exceptions.addElement(new ExceptionLabel(begin, end, handler, exc));
    }

    public void fixLabels(byte[] bytes) throws IOException {
        for (int i = 0; i < this.labels.size(); ++i) {
            ((Label)this.labels.elementAt(i)).fix(bytes);
        }
    }

    public void write(DataOutputStream stream) throws IOException {
        byte[] bytes = this.stream.toByteArray();
        this.fixLabels(bytes);
        int n = this.exceptions.size();
        int length = bytes.length + 12 + 8 * n;
        if (this.linenumbers != null) {
            length += this.linenumbers.length();
        }
        stream.writeShort(this.att_name);
        stream.writeInt(length);
        stream.writeShort(this.max_stack);
        stream.writeShort(this.nlocals);
        stream.writeInt(bytes.length);
        stream.write(bytes);
        stream.writeShort(n);
        for (int i = 0; i < n; ++i) {
            ExceptionLabel e = (ExceptionLabel)this.exceptions.elementAt(i);
            stream.writeShort(e.start.getPosition());
            stream.writeShort(e.end.getPosition());
            stream.writeShort(e.handler.getPosition());
            stream.writeShort(e.exc);
        }
        if (this.linenumbers != null) {
            ClassFile.writeAttributes(stream, new Attribute[]{this.linenumbers});
        } else {
            ClassFile.writeAttributes(stream, new Attribute[0]);
        }
    }

    public void push(int i) {
        this.stack += i;
        if (this.stack > this.max_stack) {
            this.max_stack = this.stack;
        }
        if (this.stack < 0) {
            throw new InternalError("stack < 0: " + this.stack);
        }
    }

    public void branch(int b, Label label) throws IOException {
        int offset = this.size();
        this.code.writeByte(b);
        label.setBranch(offset, 2);
        label.setStack(this.stack);
    }

    public void print(String s) throws IOException {
        this.getstatic("java/lang/System", "out", "Ljava/io/PrintStream;");
        this.ldc(s);
        this.invokevirtual("java/io/PrintStream", "println", "(Ljava/lang/String;)V");
    }

    public void aaload() throws IOException {
        this.code.writeByte(50);
        this.push(-1);
    }

    public void aastore() throws IOException {
        this.code.writeByte(83);
        this.push(-3);
    }

    public void aconst_null() throws IOException {
        this.code.writeByte(1);
        this.push(1);
    }

    public void aload(int i) throws IOException {
        if (i >= 0 && i < 4) {
            this.code.writeByte(42 + i);
        } else {
            this.code.writeByte(25);
            this.code.writeByte(i);
        }
        this.push(1);
    }

    public void anewarray(int c) throws IOException {
        this.code.writeByte(189);
        this.code.writeShort(c);
    }

    public void areturn() throws IOException {
        this.code.writeByte(176);
        this.push(-1);
    }

    public void arraylength() throws IOException {
        this.code.writeByte(190);
    }

    public void astore(int i) throws IOException {
        if (i >= 0 && i < 4) {
            this.code.writeByte(75 + i);
        } else {
            this.code.writeByte(58);
            this.code.writeByte(i);
        }
        this.push(-1);
    }

    public void athrow() throws IOException {
        this.code.writeByte(191);
        this.push(-1);
    }

    public void checkcast(int c) throws IOException {
        this.code.writeByte(192);
        this.code.writeShort(c);
    }

    public void dload(int i) throws IOException {
        if (i >= 0 && i < 4) {
            this.code.writeByte(38 + i);
        } else {
            this.code.writeByte(24);
            this.code.writeByte(i);
        }
        this.push(2);
    }

    public void dreturn() throws IOException {
        this.code.writeByte(175);
        this.push(-2);
    }

    public void dup() throws IOException {
        this.code.writeByte(89);
        this.push(1);
    }

    public void dup_x1() throws IOException {
        this.code.writeByte(90);
        this.push(1);
    }

    public void fload(int i) throws IOException {
        if (i >= 0 && i < 4) {
            this.code.writeByte(34 + i);
        } else {
            this.code.writeByte(23);
            this.code.writeByte(i);
        }
        this.push(1);
    }

    public void freturn() throws IOException {
        this.code.writeByte(174);
        this.push(-1);
    }

    public void getfield(int c) throws IOException {
        this.code.writeByte(180);
        this.code.writeShort(c);
        this.push(this.pool.sizes[c] - 1);
    }

    public void getfield(String c, String name, String type) throws IOException {
        this.getfield(this.pool.Fieldref(c, name, type));
    }

    public void getstatic(int c) throws IOException {
        this.code.writeByte(178);
        this.code.writeShort(c);
        this.push(this.pool.sizes[c]);
    }

    public void getstatic(String c, String name, String type) throws IOException {
        this.getstatic(this.pool.Fieldref(c, name, type));
    }

    public void goto_(Label label) throws IOException {
        this.branch(167, label);
    }

    public void iconst(int i) throws IOException {
        if (i >= -1 && i <= 5) {
            this.code.writeByte(3 + i);
        } else if (i > -127 && i < 128) {
            this.code.writeByte(16);
            if (i < 0) {
                i = 256 + i;
            }
            this.code.writeByte(i);
        } else if (i > -32767 && i < 32768) {
            this.code.writeByte(17);
            if (i < 0) {
                i += 65536;
            }
            this.code.writeShort(i);
        } else {
            this.ldc(this.pool.Integer(i));
        }
        this.push(1);
    }

    public void if_icmpne(Label label) throws IOException {
        this.push(-2);
        this.branch(160, label);
    }

    public void ifeq(Label label) throws IOException {
        this.push(-1);
        this.branch(153, label);
    }

    public void ifne(Label label) throws IOException {
        this.push(-1);
        this.branch(154, label);
    }

    public void ifnonnull(Label label) throws IOException {
        this.push(-1);
        this.branch(199, label);
    }

    public void ifnull(Label label) throws IOException {
        this.push(-1);
        this.branch(198, label);
    }

    public void iinc(int i, int increment) throws IOException {
        this.code.writeByte(132);
        this.code.writeByte(i);
        this.code.writeByte(increment);
    }

    public void iinc(int i) throws IOException {
        this.iinc(i, 1);
    }

    public void iload(int i) throws IOException {
        if (i >= 0 && i < 4) {
            this.code.writeByte(26 + i);
        } else {
            this.code.writeByte(21);
            this.code.writeByte(i);
        }
        this.push(1);
    }

    public void invokespecial(int c) throws IOException {
        this.code.writeByte(183);
        this.code.writeShort(c);
        this.push(this.pool.sizes[c] - 1);
    }

    public void invokestatic(int c) throws IOException {
        this.code.writeByte(184);
        this.code.writeShort(c);
        this.push(this.pool.sizes[c]);
    }

    public void invokevirtual(int c) throws IOException {
        this.code.writeByte(182);
        this.code.writeShort(c);
        this.push(this.pool.sizes[c] - 1);
    }

    public void invokevirtual(String c, String name, String type) throws IOException {
        this.invokevirtual(this.pool.Methodref(c, name, type));
    }

    public void ireturn() throws IOException {
        this.code.writeByte(172);
        this.push(-1);
    }

    public void istore(int i) throws IOException {
        if (i >= 0 && i < 4) {
            this.code.writeByte(59 + i);
        } else {
            this.code.writeByte(54);
            this.code.writeByte(i);
        }
        this.push(-1);
    }

    public void jsr(Label label) throws IOException {
        int offset = this.size();
        this.code.writeByte(168);
        label.setBranch(offset, 2);
        label.setStack(this.stack + 1);
    }

    public void ldc(int c) throws IOException {
        int size = this.pool.sizes[c];
        if (size == 1) {
            if (c < 256) {
                this.code.writeByte(18);
                this.code.writeByte(c);
            } else {
                this.code.writeByte(19);
                this.code.writeShort(c);
            }
        } else {
            this.code.writeByte(20);
            this.code.writeShort(c);
        }
        this.push(this.pool.sizes[c]);
    }

    public void ldc(String s) throws IOException {
        this.ldc(this.pool.String(s));
    }

    public void lload(int i) throws IOException {
        if (i >= 0 && i < 4) {
            this.code.writeByte(30 + i);
        } else {
            this.code.writeByte(22);
            this.code.writeByte(i);
        }
        this.push(2);
    }

    public void lreturn() throws IOException {
        this.code.writeByte(173);
        this.push(-2);
    }

    public void new_(int c) throws IOException {
        this.code.writeByte(187);
        this.code.writeShort(c);
        this.push(1);
    }

    public void pop() throws IOException {
        this.code.writeByte(87);
        this.push(-1);
    }

    public void putfield(int c) throws IOException {
        this.code.writeByte(181);
        this.code.writeShort(c);
        this.push(-this.pool.sizes[c] - 1);
    }

    public void putfield(String c, String name, String type) throws IOException {
        this.putfield(this.pool.Fieldref(c, name, type));
    }

    public void putstatic(int c) throws IOException {
        this.code.writeByte(179);
        this.code.writeShort(c);
        this.push(-this.pool.sizes[c]);
    }

    public void putstatic(String c, String name, String type) throws IOException {
        this.putstatic(this.pool.Fieldref(c, name, type));
    }

    public void return_() throws IOException {
        this.code.writeByte(177);
    }

    public void ret(int index) throws IOException {
        this.code.writeByte(169);
        this.code.writeByte(index);
    }

    public void swap() throws IOException {
        this.code.writeByte(95);
    }

    public void tableswitch(Label def, int low, Label[] labels) throws IOException {
        int position = this.size();
        this.push(-1);
        this.code.writeByte(170);
        for (int j = 0; j < 3 - position % 4; ++j) {
            this.code.writeByte(0);
        }
        def.setBranch(position, 4);
        this.code.writeInt(low);
        this.code.writeInt(labels.length - 1);
        for (int i = 0; i < labels.length; ++i) {
            labels[i].setBranch(position, 4);
        }
    }

    public void setline(int line) throws IOException {
        if (this.linenumbers == null) {
            this.linenumbers = new LineNumberTable(this.pool);
        }
        this.linenumbers.addLine(this.size(), line);
    }
}

