/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.objectAccess.array;

import gov.nasa.pds.objectAccess.array.ElementType;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;

public class ArrayAdapter {
    private int[] dimensions;
    private ElementType elementType;
    private MappedBuffer buf;

    public ArrayAdapter(int[] dimensions, SeekableByteChannel channel, ElementType elementType) {
        this.dimensions = dimensions;
        this.elementType = elementType;
        this.buf = new MappedBuffer(channel, elementType.getSize());
    }

    public int getElementSize() {
        return this.elementType.getSize();
    }

    public int getInt(int row, int column) throws IOException {
        return this.getInt(new int[]{row, column});
    }

    public long getLong(int row, int column) throws IOException {
        return this.getLong(new int[]{row, column});
    }

    public double getDouble(int row, int column) throws IOException {
        return this.getDouble(new int[]{row, column});
    }

    public int getInt(int i1, int i2, int i3) throws IOException {
        return this.getInt(new int[]{i1, i2, i3});
    }

    public long getLong(int i1, int i2, int i3) throws IOException {
        return this.getLong(new int[]{i1, i2, i3});
    }

    public double getDouble(int i1, int i2, int i3) throws IOException {
        return this.getDouble(new int[]{i1, i2, i3});
    }

    public int getInt(int[] position) throws IOException {
        this.checkDimensions(position);
        ByteBuffer buf = this.moveToPosition(position);
        return this.elementType.getAdapter().getInt(buf);
    }

    public long getLong(int[] position) throws IOException {
        this.checkDimensions(position);
        ByteBuffer buf = this.moveToPosition(position);
        return this.elementType.getAdapter().getLong(buf);
    }

    public double getDouble(int[] position) throws IOException {
        this.checkDimensions(position);
        ByteBuffer buf = this.moveToPosition(position);
        return this.elementType.getAdapter().getDouble(buf);
    }

    private ByteBuffer moveToPosition(int[] position) throws IOException {
        long index = position[0];
        for (int i = 1; i < position.length; ++i) {
            index = index * (long)this.dimensions[i] + (long)position[i];
        }
        return this.buf.getBuffer(index *= (long)this.elementType.getSize());
    }

    private void checkDimensions(int[] position) {
        if (position.length != this.dimensions.length) {
            throw new IllegalArgumentException("Array position as wrong number of dimensions: " + position.length + "!=" + this.dimensions.length);
        }
    }

    private class MappedBuffer {
        private long startPosition;
        private ByteBuffer cachedBuffer;
        private final int BUFFER_SIZE = 49941480;
        private int dataTypeSize;
        private SeekableByteChannel channel;

        public MappedBuffer(SeekableByteChannel channel, int dataTypeSize) {
            this.channel = channel;
            this.dataTypeSize = dataTypeSize;
        }

        public ByteBuffer getBuffer(long index) throws IOException {
            ByteBuffer buf = null;
            if (this.cachedBuffer == null) {
                this.cachedBuffer = buf = this.createNewBuffer(index);
            } else {
                buf = this.cachedBuffer;
            }
            if (index < this.startPosition || index + (long)this.dataTypeSize > this.startPosition + 49941480L) {
                this.cachedBuffer = buf = this.createNewBuffer(index);
            } else {
                int relativePosition = (int)(index - this.startPosition);
                buf.position(relativePosition);
            }
            return buf;
        }

        private ByteBuffer createNewBuffer(long index) throws IOException {
            this.channel.position(index);
            ByteBuffer buf = null;
            buf = this.channel.size() - this.channel.position() < 49941480L ? ByteBuffer.allocate((int)(this.channel.size() - this.channel.position())) : ByteBuffer.allocate(49941480);
            this.channel.read(buf);
            buf.flip();
            this.startPosition = index;
            return buf;
        }
    }
}

